<?php

namespace App\Config;

use PDO;

class Database
{
    private PDO $connection;

    public $statement;

    public function __construct($config, $username = 'root', $password = '')
    {
        $dsn = 'mysql:' . http_build_query($config, '', ';');

        $this->connection = new PDO($dsn, $username, $password, [
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION  // Enable exception mode for errors
        ]);
    }

    public function query($query, $params = [])
    {
        $this->statement = $this->connection->prepare($query);

        $this->statement->execute($params);

        return $this;
    }

    // fetchall 
    public function getAll()
    {
        return $this->statement->fetchAll();
    }

    public function find()
    {
        return $this->statement->fetch();
    }

    // Fetch a single column
    public function fetchColumn()
    {
        return $this->statement->fetchColumn();
    }

    // New method to get the last inserted ID
    public function lastInsertId(): string
    {
        return $this->connection->lastInsertId();
    }

    /* ---------------- new transaction helpers ---------------- */
    public function beginTransaction(): bool
    {
        return $this->connection->beginTransaction();
    }

    public function commit(): bool
    {
        return $this->connection->commit();
    }

    public function rollBack(): bool
    {
        return $this->connection->rollBack();
    }
}

